$levelPath = "..\level1"
$bytes = [System.IO.File]::ReadAllBytes($levelPath)
$pattern = [System.Text.Encoding]::UTF8.GetBytes("mguserman")

Write-Host "=== Analyzing 'mguserman' location ==="
Write-Host ""

for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $pattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $pattern[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "Found 'mguserman' at offset: 0x$($i.ToString('X8'))"
        Write-Host ""

        # Show larger context
        $start = [Math]::Max(0, $i - 100)
        $end = [Math]::Min($bytes.Length - 1, $i + 200)

        Write-Host "HEX dump (with context):"
        for ($k = $start; $k -le $end; $k += 16) {
            $hexLine = "$($k.ToString('X8')): "
            $asciiLine = ""
            $endIdx = [Math]::Min($k + 15, $end)

            for ($m = $k; $m -le $endIdx; $m++) {
                $hexLine += $bytes[$m].ToString('X2') + " "
                if ($bytes[$m] -ge 32 -and $bytes[$m] -le 126) {
                    $asciiLine += [char]$bytes[$m]
                } else {
                    $asciiLine += "."
                }
            }
            Write-Host "$hexLine | $asciiLine"
        }

        Write-Host ""
        Write-Host "Length of 'mguserman': $($pattern.Length) bytes"
        Write-Host ""

        # Check how many null bytes or spaces after
        $nullCount = 0
        for ($k = $i + $pattern.Length; $k -lt [Math]::Min($bytes.Length, $i + 100); $k++) {
            if ($bytes[$k] -eq 0) {
                $nullCount++
            } else {
                break
            }
        }
        Write-Host "Null bytes after 'mguserman': $nullCount"
        Write-Host "Available space: $($pattern.Length + $nullCount) bytes"

        break
    }
}
