$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll.backup')
Write-Host "Searching for HTTP/HTTPS URLs in Assembly-CSharp.dll.backup..."
Write-Host ""

# Convert to Unicode string
$text = [System.Text.Encoding]::Unicode.GetString($bytes)

# Find all URLs
$pattern = 'https?://[a-zA-Z0-9\-\._~:/?#\[\]@!$&''()*+,;=%]+'
$matches = [regex]::Matches($text, $pattern)

$uniqueUrls = @{}
foreach ($match in $matches) {
    $url = $match.Value
    # Clean up the URL (remove trailing nulls and junk)
    $url = $url -replace '\x00.*$', ''
    if ($url.Length -gt 10 -and $url.Length -lt 200) {
        if (-not $uniqueUrls.ContainsKey($url)) {
            $uniqueUrls[$url] = 1
        } else {
            $uniqueUrls[$url]++
        }
    }
}

Write-Host "Found URLs:"
foreach ($url in $uniqueUrls.Keys | Sort-Object) {
    Write-Host "$($uniqueUrls[$url])x - $url"
}
