# Search for "mguserman" in Assembly-CSharp.dll (UTF-16)
$dllPath = "Assembly-CSharp.dll"
$levelPath = "..\level1"

Write-Host "=== Searching for 'mguserman' ==="
Write-Host ""

# Check in DLL (UTF-16)
if (Test-Path $dllPath) {
    Write-Host "--- Checking Assembly-CSharp.dll (UTF-16) ---"
    $bytes = [System.IO.File]::ReadAllBytes($dllPath)
    $pattern = [System.Text.Encoding]::Unicode.GetBytes("mguserman")

    $found = 0
    for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $pattern.Length; $j++) {
            if ($bytes[$i + $j] -ne $pattern[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            Write-Host "Found at offset: 0x$($i.ToString('X8'))"

            # Show context
            $start = [Math]::Max(0, $i - 50)
            $end = [Math]::Min($bytes.Length - 1, $i + 100)
            $context = $bytes[$start..$end]

            Write-Host "Context (ASCII):"
            $ascii = ""
            for ($k = 0; $k -lt $context.Length; $k++) {
                if ($context[$k] -ge 32 -and $context[$k] -le 126) {
                    $ascii += [char]$context[$k]
                } else {
                    $ascii += "."
                }
            }
            Write-Host $ascii
            Write-Host ""

            $found++
            if ($found -ge 3) { break }
        }
    }

    if ($found -eq 0) {
        Write-Host "Not found in UTF-16 format"
    }
    Write-Host ""
}

# Check in level1 file
if (Test-Path $levelPath) {
    Write-Host "--- Checking level1 file ---"
    $bytes = [System.IO.File]::ReadAllBytes($levelPath)
    $pattern = [System.Text.Encoding]::UTF8.GetBytes("mguserman")

    $found = 0
    for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $pattern.Length; $j++) {
            if ($bytes[$i + $j] -ne $pattern[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            Write-Host "Found at offset: 0x$($i.ToString('X8'))"

            # Show context
            $start = [Math]::Max(0, $i - 50)
            $end = [Math]::Min($bytes.Length - 1, $i + 100)
            $context = $bytes[$start..$end]

            Write-Host "Context:"
            $ascii = ""
            for ($k = 0; $k -lt $context.Length; $k++) {
                if ($context[$k] -ge 32 -and $context[$k] -le 126) {
                    $ascii += [char]$context[$k]
                } else {
                    $ascii += "."
                }
            }
            Write-Host $ascii
            Write-Host ""

            $found++
            if ($found -ge 3) { break }
        }
    }
}
