$bundlePath = "..\StreamingAssets\aa\StandaloneWindows64\MK HORROR\ondemandgroup_scenes_all_31ca05ec5e2b7711227fda6bfbf8bde6.bundle"

if (Test-Path $bundlePath) {
    Write-Host "Checking bundle file..."
    Write-Host ""

    $bytes = [System.IO.File]::ReadAllBytes($bundlePath)
    $pattern = [System.Text.Encoding]::UTF8.GetBytes("mguserman")

    Write-Host "File size: $($bytes.Length) bytes"
    Write-Host ""

    $found = 0
    for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $pattern.Length; $j++) {
            if ($bytes[$i + $j] -ne $pattern[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            Write-Host "Found 'mguserman' at offset: 0x$($i.ToString('X8'))"

            # Show context
            $start = [Math]::Max(0, $i - 50)
            $end = [Math]::Min($bytes.Length - 1, $i + 100)
            $context = $bytes[$start..$end]

            Write-Host "HEX context:"
            for ($k = 0; $k -lt [Math]::Min(80, $context.Length); $k += 16) {
                $hexLine = ""
                $asciiLine = ""
                for ($m = $k; $m -lt [Math]::Min($k + 16, $context.Length); $m++) {
                    $hexLine += $context[$m].ToString('X2') + " "
                    if ($context[$m] -ge 32 -and $context[$m] -le 126) {
                        $asciiLine += [char]$context[$m]
                    } else {
                        $asciiLine += "."
                    }
                }
                Write-Host "$hexLine | $asciiLine"
            }
            Write-Host ""

            $found++
            if ($found -ge 3) { break }
        }
    }

    if ($found -eq 0) {
        Write-Host "NOT FOUND in this bundle"
    } else {
        Write-Host "Total found: $found"
    }
} else {
    Write-Host "Bundle file not found at: $bundlePath"
}
