$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll')
Write-Host "Searching for rain-related parameters..."
Write-Host ""

# Convert to Unicode string
$text = [System.Text.Encoding]::Unicode.GetString($bytes)

# Split by nulls and search
$lines = $text -split "`0" | Where-Object {
    $_ -match '(?i)(rain|weather|particle|drop|fall|precip|speed|velocity)' -and
    $_.Length -gt 3 -and
    $_.Length -lt 100
}

# Show unique results
$unique = $lines | Select-Object -Unique | Sort-Object

Write-Host "Found potential rain/weather related strings:"
$unique | ForEach-Object { Write-Host $_ }
