$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll')
$text = [System.Text.Encoding]::ASCII.GetString($bytes)

Write-Host "Searching for RainMaker speed parameters..."
Write-Host ""

# Search for RainMaker related strings
if ($text -match 'RainMaker') {
    Write-Host "Found RainMaker references"
}

# Search for speed/velocity related fields near RainMaker
$patterns = @(
    'Speed',
    'Velocity',
    'Fall',
    'Intensity',
    'Rate',
    'Gravity'
)

foreach ($pattern in $patterns) {
    $regex = [regex]"(?i)rain.*$pattern|$pattern.*rain"
    $matches = $regex.Matches($text)
    if ($matches.Count -gt 0) {
        Write-Host "Found pattern: $pattern"
        foreach ($match in $matches | Select-Object -First 5) {
            $start = [Math]::Max(0, $match.Index - 30)
            $length = [Math]::Min(100, $text.Length - $start)
            $context = $text.Substring($start, $length) -replace '[^\x20-\x7E]', '.'
            Write-Host "  Context: $context"
        }
    }
}
