$inputFile = "C:\Users\Samurai\AppData\Local\Temp\apk-editor-studio\apk\{39f22a3d-a10e-473f-908c-320d60b76079}\assets\bin\Data\Managed\Metadata\global-metadata.dat"
$bytes = [System.IO.File]::ReadAllBytes($inputFile)

# Search for shorter pattern that should definitely be there
$pattern = [System.Text.Encoding]::UTF8.GetBytes("youtube.com/channel")

Write-Host "Searching for 'youtube.com/channel' pattern..."
Write-Host "Pattern bytes:" ($pattern | ForEach-Object { $_.ToString('X2') }) -join ' '

for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $pattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $pattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host ""
        Write-Host "===== FOUND at offset: 0x$($i.ToString('X8')) ====="
        $start = [Math]::Max(0, $i - 30)
        $end = [Math]::Min($bytes.Length - 1, $i + 100)
        $context = $bytes[$start..$end]

        Write-Host "Hex dump:"
        for ($k = 0; $k -lt $context.Length; $k += 16) {
            $hexLine = ""
            $asciiLine = ""
            $endIdx = [Math]::Min($k + 15, $context.Length - 1)
            for ($m = $k; $m -le $endIdx; $m++) {
                $hexLine += $context[$m].ToString('X2') + " "
                if ($context[$m] -ge 32 -and $context[$m] -le 126) {
                    $asciiLine += [char]$context[$m]
                } else {
                    $asciiLine += "."
                }
            }
            Write-Host "$hexLine | $asciiLine"
        }
        break
    }
}
