# Search for UTF-16 encoded YouTube URL
$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll.backup')

$searchText = "https://youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q"
$pattern = [System.Text.Encoding]::Unicode.GetBytes($searchText)

Write-Host "Searching for UTF-16 YouTube URL..."
Write-Host "Text: $searchText"
Write-Host "Pattern length: $($pattern.Length) bytes"

$found = 0
for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $pattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $pattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "FOUND UTF-16 YouTube URL at offset: 0x$($i.ToString('X8'))"
        $found++
    }

    if ($i % 1000000 -eq 0) {
        Write-Host "Progress: $([Math]::Round($i / $bytes.Length * 100, 1))%"
    }
}

Write-Host ""
Write-Host "Total found: $found"
