$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll.backup')
Write-Host "File size: $($bytes.Length) bytes"

# UTF-16 patterns
$oldText = "https://t.me/euphoriagamesstudio"
$newText = "https://t.me/mimicry_mk_horror" + "`0`0`0"  # Padding to same length

$oldPattern = [System.Text.Encoding]::Unicode.GetBytes($oldText)
$newPattern = [System.Text.Encoding]::Unicode.GetBytes($newText)

Write-Host "Old: $oldText ($($oldPattern.Length) bytes)"
Write-Host "New: $newText ($($newPattern.Length) bytes)"

if ($oldPattern.Length -ne $newPattern.Length) {
    Write-Host "ERROR: Pattern lengths don't match!"
    Write-Host "Old length: $($oldPattern.Length)"
    Write-Host "New length: $($newPattern.Length)"
    # Adjust new pattern to match old length
    if ($newPattern.Length -lt $oldPattern.Length) {
        $diff = $oldPattern.Length - $newPattern.Length
        $newPattern += ,0 * $diff
        Write-Host "Padded new pattern to $($newPattern.Length) bytes"
    }
}

# Search and replace
$replaced = 0
$i = 0
while ($i -le ($bytes.Length - $oldPattern.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "Replacing at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newPattern.Length; $j++) {
            $bytes[$i + $j] = $newPattern[$j]
        }
        $replaced++
        $i += $oldPattern.Length
    } else {
        $i++
    }
}

Write-Host "Total replacements: $replaced"

if ($replaced -gt 0) {
    [System.IO.File]::WriteAllBytes('Assembly-CSharp.dll', $bytes)
    Write-Host "SUCCESS! Saved to Assembly-CSharp.dll"

    # Verify
    $verify = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll')
    $verifyOld = [System.Text.Encoding]::Unicode.GetBytes($oldText)
    $verifyNew = [System.Text.Encoding]::Unicode.GetBytes("https://t.me/mimicry_mk_horror")

    Write-Host ""
    Write-Host "Verification:"

    $foundOld = $false
    for ($i = 0; $i -lt ($verify.Length - $verifyOld.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $verifyOld.Length; $j++) {
            if ($verify[$i + $j] -ne $verifyOld[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            $foundOld = $true
            break
        }
    }

    if ($foundOld) {
        Write-Host "WARNING: Old URL still found!"
    } else {
        Write-Host "✓ Old URL removed"
    }

    $foundNew = $false
    for ($i = 0; $i -lt ($verify.Length - $verifyNew.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $verifyNew.Length; $j++) {
            if ($verify[$i + $j] -ne $verifyNew[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            $foundNew = $true
            break
        }
    }

    if ($foundNew) {
        Write-Host "✓ New URL present"
    } else {
        Write-Host "WARNING: New URL not found!"
    }
} else {
    Write-Host "ERROR: No matches found"
}
