# Replace YouTube URL in APK metadata file
$apkPath = "C:\Users\Samurai\AppData\Local\Temp\apk-editor-studio\apk\{39f22a3d-a10e-473f-908c-320d60b76079}\assets\bin\Data\Managed\Metadata\global-metadata.dat"

if (Test-Path $apkPath) {
    # Create backup first
    $backupPath = $apkPath + ".youtube.backup"
    if (-not (Test-Path $backupPath)) {
        Copy-Item $apkPath $backupPath
        Write-Host "Backup created: $backupPath"
    }

    # Read file as bytes
    $bytes = [System.IO.File]::ReadAllBytes($apkPath)
    Write-Host "File size: $($bytes.Length) bytes"

    # Old and new YouTube URLs (ASCII encoding for APK)
    $oldText = "https://youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q"
    $newText = "https://www.youtube.com/@mk_horror" + "`0" * 7  # Padding to match length

    $oldPattern = [System.Text.Encoding]::UTF8.GetBytes($oldText)
    $newPattern = [System.Text.Encoding]::UTF8.GetBytes($newText)

    Write-Host "Old: $oldText ($($oldPattern.Length) bytes)"
    Write-Host "New: $newText ($($newPattern.Length) bytes)"

    # Adjust padding if needed
    if ($oldPattern.Length -ne $newPattern.Length) {
        Write-Host "Adjusting padding..."
        if ($newPattern.Length -lt $oldPattern.Length) {
            $diff = $oldPattern.Length - $newPattern.Length
            $padding = ,0 * $diff
            $newPattern = $newPattern + $padding
            Write-Host "Padded new pattern to $($newPattern.Length) bytes"
        }
    }

    # Search and replace
    $replaced = 0
    $i = 0
    while ($i -le ($bytes.Length - $oldPattern.Length)) {
        $match = $true
        for ($j = 0; $j -lt $oldPattern.Length; $j++) {
            if ($bytes[$i + $j] -ne $oldPattern[$j]) {
                $match = $false
                break
            }
        }

        if ($match) {
            Write-Host "Found match at offset: 0x$($i.ToString('X8'))"
            for ($j = 0; $j -lt $newPattern.Length; $j++) {
                $bytes[$i + $j] = $newPattern[$j]
            }
            $replaced++
            $i += $oldPattern.Length
        } else {
            $i++
        }
    }

    Write-Host "Total replacements: $replaced"

    # Save if any replacements were made
    if ($replaced -gt 0) {
        [System.IO.File]::WriteAllBytes($apkPath, $bytes)
        Write-Host "SUCCESS: Saved to $apkPath"

        # Verify
        Write-Host ""
        Write-Host "Verification:"
        $verify = [System.IO.File]::ReadAllBytes($apkPath)
        $verifyOld = [System.Text.Encoding]::UTF8.GetBytes($oldText)

        $foundOld = $false
        for ($i = 0; $i -lt ($verify.Length - $verifyOld.Length); $i++) {
            $match = $true
            for ($j = 0; $j -lt $verifyOld.Length; $j++) {
                if ($verify[$i + $j] -ne $verifyOld[$j]) {
                    $match = $false
                    break
                }
            }
            if ($match) {
                $foundOld = $true
                break
            }
        }

        if ($foundOld) {
            Write-Host "WARNING: Old YouTube URL still found!"
        } else {
            Write-Host "✓ Old YouTube URL removed"
        }
    } else {
        Write-Host "WARNING: No matches found"
    }
} else {
    Write-Host "ERROR: APK metadata file not found at: $apkPath"
}
