$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll')
Write-Host "=== Checking ALL Links in Assembly-CSharp.dll ==="
Write-Host ""

# Check Telegram
Write-Host "--- TELEGRAM ---"
$oldTG = [System.Text.Encoding]::Unicode.GetBytes('https://t.me/euphoriagamesstudio')
$newTG = [System.Text.Encoding]::Unicode.GetBytes('https://t.me/mimicry_mk_horror')

$foundOldTG = 0
$foundNewTG = 0

for ($i = 0; $i -lt ($bytes.Length - $oldTG.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $oldTG.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldTG[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "OLD Telegram at: 0x$($i.ToString('X8'))"
        $foundOldTG++
    }
}

for ($i = 0; $i -lt ($bytes.Length - $newTG.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $newTG.Length; $j++) {
        if ($bytes[$i + $j] -ne $newTG[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "NEW Telegram at: 0x$($i.ToString('X8'))"
        $foundNewTG++
    }
}

Write-Host "Old Telegram URLs: $foundOldTG"
Write-Host "New Telegram URLs: $foundNewTG"
Write-Host ""

# Check YouTube
Write-Host "--- YOUTUBE ---"
$oldYT = [System.Text.Encoding]::Unicode.GetBytes('https://www.youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q')
$newYT = [System.Text.Encoding]::Unicode.GetBytes('https://www.youtube.com/@mk_horror')

$foundOldYT = 0
$foundNewYT = 0

for ($i = 0; $i -lt ($bytes.Length - $oldYT.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $oldYT.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldYT[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "OLD YouTube at: 0x$($i.ToString('X8'))"
        $foundOldYT++
    }
}

for ($i = 0; $i -lt ($bytes.Length - $newYT.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $newYT.Length; $j++) {
        if ($bytes[$i + $j] -ne $newYT[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "NEW YouTube at: 0x$($i.ToString('X8'))"
        $foundNewYT++
    }
}

Write-Host "Old YouTube URLs: $foundOldYT"
Write-Host "New YouTube URLs: $foundNewYT"
Write-Host ""

# Summary
Write-Host "=== SUMMARY ==="
if ($foundOldTG -gt 0 -or $foundOldYT -gt 0) {
    Write-Host "STATUS: PROBLEM - Old URLs still present!"
    Write-Host "Need to replace again"
} else {
    Write-Host "STATUS: OK - All URLs replaced"
}
