# Binary string replacement in DLL
$inputFile = "Assembly-CSharp.dll.backup"
$outputFile = "Assembly-CSharp.dll"

# Read file as bytes
$bytes = [System.IO.File]::ReadAllBytes($inputFile)
Write-Host "File size: $($bytes.Length) bytes"

# Old and new URLs (as byte arrays)
$oldBytes = [byte[]]@(104, 116, 116, 112, 115, 58, 47, 47, 116, 46, 109, 101, 47, 101, 117, 112, 104, 111, 114, 105, 97, 103, 97, 109, 101, 115, 115, 116, 117, 100, 105, 111)
$newBytes = [byte[]]@(104, 116, 116, 112, 115, 58, 47, 47, 116, 46, 109, 101, 47, 109, 105, 109, 105, 99, 114, 121, 95, 109, 107, 95, 104, 111, 114, 114, 111, 114, 0, 0, 0)

Write-Host "Old: https://t.me/euphoriagamesstudio ($($oldBytes.Length) bytes)"
Write-Host "New: https://t.me/mimicry_mk_horror ($($newBytes.Length) bytes)"

# Search and replace
$i = 0
$replaced = 0
while ($i -le ($bytes.Length - $oldBytes.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldBytes.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldBytes[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "Found match at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newBytes.Length; $j++) {
            $bytes[$i + $j] = $newBytes[$j]
        }
        $replaced++
        $i += $oldBytes.Length
    } else {
        $i++
    }
}

Write-Host "Total replacements: $replaced"

# Save if any replacements were made
if ($replaced -gt 0) {
    [System.IO.File]::WriteAllBytes($outputFile, $bytes)
    Write-Host "SUCCESS: Saved to $outputFile"
} else {
    Write-Host "WARNING: No matches found, file not modified"
}
