# Search for UTF-16 encoded URL
$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll.backup')

# Try UTF-16 LE encoding for "https://t.me/"
$searchText = "https://t.me/euphoriagamesstudio"
$pattern = [System.Text.Encoding]::Unicode.GetBytes($searchText)

Write-Host "Searching for UTF-16 pattern..."
Write-Host "Text: $searchText"
Write-Host "Pattern length: $($pattern.Length) bytes"
Write-Host "First bytes:" ($pattern[0..20] | ForEach-Object { $_.ToString('X2') }) -join ' '

$found = 0
for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $pattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $pattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "FOUND UTF-16 at offset: 0x$($i.ToString('X8'))"
        $found++
    }

    if ($i % 1000000 -eq 0) {
        Write-Host "Progress: $([Math]::Round($i / $bytes.Length * 100, 1))%"
    }
}

if ($found -eq 0) {
    Write-Host "Not found in UTF-16"
    Write-Host ""
    Write-Host "Trying ASCII with null separators..."

    # Try pattern like "h\0t\0t\0p\0s..."
    $asciiBytes = [System.Text.Encoding]::ASCII.GetBytes("t.me")
    $patternWithNull = @()
    foreach ($b in $asciiBytes) {
        $patternWithNull += $b
        $patternWithNull += 0
    }

    Write-Host "Pattern with nulls:" ($patternWithNull | ForEach-Object { $_.ToString('X2') }) -join ' '

    for ($i = 0; $i -lt ($bytes.Length - $patternWithNull.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $patternWithNull.Length; $j++) {
            if ($bytes[$i + $j] -ne $patternWithNull[$j]) {
                $match = $false
                break
            }
        }

        if ($match) {
            Write-Host "FOUND ASCII+null pattern at: 0x$($i.ToString('X8'))"
            $start = [Math]::Max(0, $i - 10)
            $end = [Math]::Min($bytes.Length - 1, $i + 100)
            Write-Host "Context hex:" ($bytes[$start..$end] | ForEach-Object { $_.ToString('X2') }) -join ' '
            break
        }
    }
}

Write-Host "Search complete"
