# Search for ASCII encoded YouTube URL in APK metadata
$apkPath = "C:\Users\Samurai\AppData\Local\Temp\apk-editor-studio\apk\{39f22a3d-a10e-473f-908c-320d60b76079}\assets\bin\Data\Managed\Metadata\global-metadata.dat"

if (Test-Path $apkPath) {
    $bytes = [System.IO.File]::ReadAllBytes($apkPath)

    $searchText = "https://youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q"
    $pattern = [System.Text.Encoding]::UTF8.GetBytes($searchText)

    Write-Host "Searching for ASCII YouTube URL in APK metadata..."
    Write-Host "Text: $searchText"
    Write-Host "Pattern length: $($pattern.Length) bytes"

    $found = 0
    for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $pattern.Length; $j++) {
            if ($bytes[$i + $j] -ne $pattern[$j]) {
                $match = $false
                break
            }
        }

        if ($match) {
            Write-Host "FOUND ASCII YouTube URL at offset: 0x$($i.ToString('X8'))"
            $found++
        }

        if ($i % 1000000 -eq 0) {
            Write-Host "Progress: $([Math]::Round($i / $bytes.Length * 100, 1))%"
        }
    }

    Write-Host ""
    Write-Host "Total found: $found"
} else {
    Write-Host "APK metadata file not found at: $apkPath"
}
