$bundlePath = "..\StreamingAssets\aa\StandaloneWindows64\MK HORROR\ondemandgroup_scenes_all_31ca05ec5e2b7711227fda6bfbf8bde6.bundle"
$backupPath = $bundlePath + ".backup"

Write-Host "=== Replacing mguserman in bundle file ==="
Write-Host ""

# Create backup
if (-not (Test-Path $backupPath)) {
    Write-Host "Creating backup (this may take a moment)..."
    Copy-Item $bundlePath $backupPath
    Write-Host "Backup created"
}

Write-Host "Loading bundle file..."
$bytes = [System.IO.File]::ReadAllBytes($bundlePath)
Write-Host "File size: $($bytes.Length) bytes"
Write-Host ""

# Old: "mguserman" (9 bytes)
$oldPattern = [System.Text.Encoding]::UTF8.GetBytes("mguserman")

# New: "MK HORROR\nEdward" (16 bytes)
$newText = "MK HORROR`nEdward"
$newPattern = [System.Text.Encoding]::UTF8.GetBytes($newText)

Write-Host "Old: 'mguserman' ($($oldPattern.Length) bytes)"
Write-Host "New: 'MK HORROR\nEdward' ($($newPattern.Length) bytes)"
Write-Host ""

# Find and replace all occurrences
$replaced = 0
$i = 0
while ($i -le ($bytes.Length - $oldPattern.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "Found at offset: 0x$($i.ToString('X8'))"

        # Check if there's a length field 4 bytes before
        if ($i -ge 4) {
            $lengthOffset = $i - 4
            $currentLength = $bytes[$lengthOffset]

            if ($currentLength -eq 9) {
                # Update length
                $bytes[$lengthOffset] = 16
                Write-Host "  Updated length field at 0x$($lengthOffset.ToString('X8'))"
            }
        }

        # Replace the string
        for ($j = 0; $j -lt $newPattern.Length; $j++) {
            $bytes[$i + $j] = $newPattern[$j]
        }

        # Pad with zeros if needed
        for ($j = $newPattern.Length; $j -lt 16; $j++) {
            if ($i + $j -lt $bytes.Length) {
                $bytes[$i + $j] = 0
            }
        }

        $replaced++
        $i += $oldPattern.Length
    } else {
        $i++
    }

    # Progress
    if ($i % 10000000 -eq 0) {
        $progress = [Math]::Round($i / $bytes.Length * 100, 1)
        Write-Host "Progress: $progress%"
    }
}

Write-Host ""
Write-Host "Total replacements: $replaced"

if ($replaced -gt 0) {
    Write-Host ""
    Write-Host "Saving bundle file (this may take a moment)..."
    [System.IO.File]::WriteAllBytes($bundlePath, $bytes)
    Write-Host "SUCCESS! Bundle file updated"
} else {
    Write-Host "ERROR: No matches found"
}
