$levelPath = "..\level1"
$backupPath = "..\level1.backup"

# Create backup
if (-not (Test-Path $backupPath)) {
    Copy-Item $levelPath $backupPath
    Write-Host "Backup created: level1.backup"
}

$bytes = [System.IO.File]::ReadAllBytes($levelPath)
Write-Host "File size: $($bytes.Length) bytes"
Write-Host ""

# Old pattern: "mguserman" (9 bytes)
$oldPattern = [System.Text.Encoding]::UTF8.GetBytes("mguserman")

# New pattern: "Edward\nMK HORROR" (16 bytes)
$newText = "Edward`nMK HORROR"
$newPattern = [System.Text.Encoding]::UTF8.GetBytes($newText)

Write-Host "Old text: 'mguserman' ($($oldPattern.Length) bytes)"
Write-Host "New text: 'Edward\nMK HORROR' ($($newPattern.Length) bytes)"
Write-Host ""

# Find and replace
$replaced = 0
for ($i = 0; $i -lt ($bytes.Length - $oldPattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "Found at offset: 0x$($i.ToString('X8'))"

        # Update length field (4 bytes before the string)
        $lengthOffset = $i - 4
        $newLength = $newPattern.Length
        $bytes[$lengthOffset] = $newLength
        $bytes[$lengthOffset + 1] = 0
        $bytes[$lengthOffset + 2] = 0
        $bytes[$lengthOffset + 3] = 0

        Write-Host "Updated length field at 0x$($lengthOffset.ToString('X8')) to $newLength"

        # Replace the string
        for ($j = 0; $j -lt $newPattern.Length; $j++) {
            $bytes[$i + $j] = $newPattern[$j]
        }

        # Fill remaining space with zeros
        for ($j = $newPattern.Length; $j -lt 16; $j++) {
            $bytes[$i + $j] = 0
        }

        Write-Host "Replaced nickname at offset: 0x$($i.ToString('X8'))"
        $replaced++
        break
    }
}

Write-Host ""
Write-Host "Total replacements: $replaced"

if ($replaced -gt 0) {
    [System.IO.File]::WriteAllBytes($levelPath, $bytes)
    Write-Host "SUCCESS! Saved to level1"

    # Verify
    Write-Host ""
    Write-Host "Verification:"
    $verify = [System.IO.File]::ReadAllBytes($levelPath)
    $verifyPattern = [System.Text.Encoding]::UTF8.GetBytes("Edward")

    $found = $false
    for ($i = 0; $i -lt ($verify.Length - $verifyPattern.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $verifyPattern.Length; $j++) {
            if ($verify[$i + $j] -ne $verifyPattern[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            Write-Host "OK: 'Edward' found at 0x$($i.ToString('X8'))"

            # Show context
            $context = ""
            for ($k = 0; $k -lt 20; $k++) {
                $byte = $verify[$i + $k]
                if ($byte -eq 10) {
                    $context += "\n"
                } elseif ($byte -ge 32 -and $byte -le 126) {
                    $context += [char]$byte
                } else {
                    $context += "."
                }
            }
            Write-Host "Preview: '$context'"
            $found = $true
            break
        }
    }

    if (-not $found) {
        Write-Host "WARNING: Could not verify replacement"
    }
} else {
    Write-Host "ERROR: Pattern not found"
}
