# Replace both Mist-related links in Assembly-CSharp.dll
$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll')
Write-Host "File size: $($bytes.Length) bytes"
Write-Host ""

$totalReplaced = 0

# === REPLACEMENT 1: euphoriagames.ru ===
Write-Host "=== Replacing euphoriagames.ru ==="
$oldUrl1 = "https://euphoriagames.ru"
$newUrl1 = "https://mimicry.lol/"

$oldPattern1 = [System.Text.Encoding]::Unicode.GetBytes($oldUrl1)
$newPattern1 = [System.Text.Encoding]::Unicode.GetBytes($newUrl1)

Write-Host "Old: $oldUrl1"
Write-Host "New: https://mimicry.lol/"

if ($newPattern1.Length -lt $oldPattern1.Length) {
    $diff = $oldPattern1.Length - $newPattern1.Length
    $padding = ,0 * $diff
    $newPattern1 = $newPattern1 + $padding
}

$replaced1 = 0
$i = 0
while ($i -le ($bytes.Length - $oldPattern1.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern1.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern1[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "Replacing at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newPattern1.Length; $j++) {
            $bytes[$i + $j] = $newPattern1[$j]
        }
        $replaced1++
        $i += $oldPattern1.Length
    } else {
        $i++
    }
}

Write-Host "Replacements: $replaced1"
Write-Host ""

# === REPLACEMENT 2: Play Store Mist link ===
Write-Host "=== Replacing Play Store Mist link ==="
$oldUrl2 = "https://play.google.com/store/apps/details?id=com.eg.mist.horror.idle.rpg"
$newUrl2 = "https://mimicry.lol/"

$oldPattern2 = [System.Text.Encoding]::Unicode.GetBytes($oldUrl2)
$newPattern2 = [System.Text.Encoding]::Unicode.GetBytes($newUrl2)

Write-Host "Old: $oldUrl2"
Write-Host "New: https://mimicry.lol/"

if ($newPattern2.Length -lt $oldPattern2.Length) {
    $diff = $oldPattern2.Length - $newPattern2.Length
    $padding = ,0 * $diff
    $newPattern2 = $newPattern2 + $padding
}

$replaced2 = 0
$i = 0
while ($i -le ($bytes.Length - $oldPattern2.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern2.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern2[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "Replacing at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newPattern2.Length; $j++) {
            $bytes[$i + $j] = $newPattern2[$j]
        }
        $replaced2++
        $i += $oldPattern2.Length
    } else {
        $i++
    }
}

Write-Host "Replacements: $replaced2"
Write-Host ""

$totalReplaced = $replaced1 + $replaced2

# === SAVE FILE ===
if ($totalReplaced -gt 0) {
    [System.IO.File]::WriteAllBytes('Assembly-CSharp.dll', $bytes)
    Write-Host "=== SUCCESS! ==="
    Write-Host "Total replacements: $totalReplaced"
    Write-Host "  euphoriagames.ru: $replaced1"
    Write-Host "  Play Store Mist: $replaced2"
    Write-Host "Saved to Assembly-CSharp.dll"
} else {
    Write-Host "WARNING: No replacements made"
}
