$inputFile = "C:\Users\Samurai\AppData\Local\Temp\apk-editor-studio\apk\{39f22a3d-a10e-473f-908c-320d60b76079}\assets\bin\Data\Managed\Metadata\global-metadata.dat"
$outputFile = $inputFile

$bytes = [System.IO.File]::ReadAllBytes($inputFile)
Write-Host "File size: $($bytes.Length) bytes"

# Old: https://www.youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q (56 bytes)
$oldBytes = [byte[]]@(104,116,116,112,115,58,47,47,119,119,119,46,121,111,117,116,117,98,101,46,99,111,109,47,99,104,97,110,110,101,108,47,85,67,53,120,115,84,120,84,121,115,75,85,106,53,49,104,86,110,95,49,116,77,57,81)

# New: https://www.youtube.com/@mk_horror (33 bytes) + 23 nulls = 56 bytes
$newBytes = [byte[]]@(104,116,116,112,115,58,47,47,119,119,119,46,121,111,117,116,117,98,101,46,99,111,109,47,64,109,107,95,104,111,114,114,111,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)

Write-Host "Old: https://www.youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q"
Write-Host "Old length: $($oldBytes.Length) bytes"
Write-Host "New: https://www.youtube.com/@mk_horror"
Write-Host "New length: $($newBytes.Length) bytes"

$i = 0
$replaced = 0
while ($i -le ($bytes.Length - $oldBytes.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldBytes.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldBytes[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "Found match at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newBytes.Length; $j++) {
            $bytes[$i + $j] = $newBytes[$j]
        }
        $replaced++
        $i += $oldBytes.Length
    } else {
        $i++
    }
}

Write-Host "Total replacements: $replaced"

if ($replaced -gt 0) {
    [System.IO.File]::WriteAllBytes($outputFile, $bytes)
    Write-Host "SUCCESS: YouTube URL replaced in APK!"

    Write-Host ""
    Write-Host "Verification:"
    $verify = [System.IO.File]::ReadAllBytes($outputFile)

    $foundOld = $false
    for ($i = 0; $i -lt ($verify.Length - $oldBytes.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $oldBytes.Length; $j++) {
            if ($verify[$i + $j] -ne $oldBytes[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            $foundOld = $true
            break
        }
    }

    if ($foundOld) {
        Write-Host "WARNING: Old URL still found!"
    } else {
        Write-Host "OK: Old URL removed"
    }
} else {
    Write-Host "WARNING: No matches found"
}
