$levelPath = "..\level1"

$bytes = [System.IO.File]::ReadAllBytes($levelPath)
Write-Host "Swapping nicknames..."
Write-Host ""

# Find "Edward"
$oldPattern = [System.Text.Encoding]::UTF8.GetBytes("Edward")

# New pattern: "MK HORROR\nEdward" (16 bytes)
$newText = "MK HORROR`nEdward"
$newPattern = [System.Text.Encoding]::UTF8.GetBytes($newText)

Write-Host "Old: 'Edward\nMK HORROR'"
Write-Host "New: 'MK HORROR\nEdward'"
Write-Host "Length: $($newPattern.Length) bytes"
Write-Host ""

# Find and replace
$replaced = 0
for ($i = 0; $i -lt ($bytes.Length - $oldPattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "Found 'Edward' at offset: 0x$($i.ToString('X8'))"

        # Replace the string (length stays 16, so no need to update length field)
        for ($j = 0; $j -lt $newPattern.Length; $j++) {
            $bytes[$i + $j] = $newPattern[$j]
        }

        Write-Host "Swapped nicknames at offset: 0x$($i.ToString('X8'))"
        $replaced++
        break
    }
}

Write-Host ""
Write-Host "Total replacements: $replaced"

if ($replaced -gt 0) {
    [System.IO.File]::WriteAllBytes($levelPath, $bytes)
    Write-Host "SUCCESS! Saved to level1"

    # Verify
    Write-Host ""
    Write-Host "Verification:"
    $verify = [System.IO.File]::ReadAllBytes($levelPath)
    $verifyPattern = [System.Text.Encoding]::UTF8.GetBytes("MK HORROR")

    $found = $false
    for ($i = 0; $i -lt ($verify.Length - $verifyPattern.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $verifyPattern.Length; $j++) {
            if ($verify[$i + $j] -ne $verifyPattern[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            Write-Host "OK: 'MK HORROR' found at 0x$($i.ToString('X8'))"

            # Show context
            $context = ""
            for ($k = 0; $k -lt 20; $k++) {
                $byte = $verify[$i + $k]
                if ($byte -eq 10) {
                    $context += " | "
                } elseif ($byte -ge 32 -and $byte -le 126) {
                    $context += [char]$byte
                } else {
                    break
                }
            }
            Write-Host "Preview: '$context'"
            $found = $true
            break
        }
    }

    if (-not $found) {
        Write-Host "WARNING: Could not verify replacement"
    }
} else {
    Write-Host "ERROR: Pattern not found"
}
