$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll')
Write-Host "Checking YouTube URLs in Assembly-CSharp.dll..."

$oldPattern = [System.Text.Encoding]::Unicode.GetBytes('https://www.youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q')
$newPattern = [System.Text.Encoding]::Unicode.GetBytes('https://www.youtube.com/@mk_horror')

$foundOld = 0
$foundNew = 0

for ($i = 0; $i -lt ($bytes.Length - $oldPattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "Found OLD YouTube URL at: 0x$($i.ToString('X8'))"
        $foundOld++
    }
}

for ($i = 0; $i -lt ($bytes.Length - $newPattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $newPattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $newPattern[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "Found NEW YouTube URL at: 0x$($i.ToString('X8'))"
        $foundNew++
    }
}

Write-Host ""
Write-Host "Summary:"
Write-Host "Old YouTube URLs found: $foundOld"
Write-Host "New YouTube URLs found: $foundNew"
