$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll.backup')
$pattern = [System.Text.Encoding]::ASCII.GetBytes('t.me/euphor')

Write-Host "Searching for 't.me/euphor' pattern..."
Write-Host "Pattern bytes:" ($pattern | ForEach-Object { $_.ToString('X2') }) -join ' '

for ($i = 0; $i -lt ($bytes.Length - $pattern.Length); $i++) {
    $match = $true
    for ($j = 0; $j -lt $pattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $pattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host ""
        Write-Host "===== FOUND at offset: 0x$($i.ToString('X8')) ====="
        $start = [Math]::Max(0, $i - 20)
        $end = [Math]::Min($bytes.Length - 1, $i + 80)
        $context = $bytes[$start..$end]

        Write-Host "Hex dump:"
        for ($k = 0; $k -lt $context.Length; $k += 16) {
            $hexLine = ""
            $asciiLine = ""
            $endIdx = [Math]::Min($k + 15, $context.Length - 1)
            for ($m = $k; $m -le $endIdx; $m++) {
                $hexLine += $context[$m].ToString('X2') + " "
                if ($context[$m] -ge 32 -and $context[$m] -le 126) {
                    $asciiLine += [char]$context[$m]
                } else {
                    $asciiLine += "."
                }
            }
            Write-Host "$hexLine | $asciiLine"
        }

        # Only show first match
        if ($i -gt 100000) { break }
    }
}

Write-Host ""
Write-Host "Search complete"
