# Replace both Telegram and YouTube links in Assembly-CSharp.dll
$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll.backup')
Write-Host "File size: $($bytes.Length) bytes"
Write-Host ""

# === TELEGRAM REPLACEMENT ===
Write-Host "=== Replacing Telegram URLs ==="
$oldTelegram = "https://t.me/euphoriagamesstudio"
$newTelegram = "https://t.me/mimicry_mk_horror" + "`0`0`0"

$oldPatternTG = [System.Text.Encoding]::Unicode.GetBytes($oldTelegram)
$newPatternTG = [System.Text.Encoding]::Unicode.GetBytes($newTelegram)

Write-Host "Old: $oldTelegram"
Write-Host "New: https://t.me/mimicry_mk_horror"

if ($newPatternTG.Length -lt $oldPatternTG.Length) {
    $diff = $oldPatternTG.Length - $newPatternTG.Length
    $padding = ,0 * $diff
    $newPatternTG = $newPatternTG + $padding
}

$replacedTG = 0
$i = 0
while ($i -le ($bytes.Length - $oldPatternTG.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldPatternTG.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPatternTG[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "Replacing Telegram at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newPatternTG.Length; $j++) {
            $bytes[$i + $j] = $newPatternTG[$j]
        }
        $replacedTG++
        $i += $oldPatternTG.Length
    } else {
        $i++
    }
}

Write-Host "Telegram replacements: $replacedTG"
Write-Host ""

# === YOUTUBE REPLACEMENT ===
Write-Host "=== Replacing YouTube URLs ==="
$oldYouTube = "https://www.youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q"
$newYouTube = "https://www.youtube.com/@mk_horror"

$oldPatternYT = [System.Text.Encoding]::Unicode.GetBytes($oldYouTube)
$newPatternYT = [System.Text.Encoding]::Unicode.GetBytes($newYouTube)

Write-Host "Old: $oldYouTube"
Write-Host "New: $newYouTube"

if ($newPatternYT.Length -lt $oldPatternYT.Length) {
    $diff = $oldPatternYT.Length - $newPatternYT.Length
    $padding = ,0 * $diff
    $newPatternYT = $newPatternYT + $padding
}

$replacedYT = 0
$i = 0
while ($i -le ($bytes.Length - $oldPatternYT.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldPatternYT.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPatternYT[$j]) {
            $match = $false
            break
        }
    }
    if ($match) {
        Write-Host "Replacing YouTube at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newPatternYT.Length; $j++) {
            $bytes[$i + $j] = $newPatternYT[$j]
        }
        $replacedYT++
        $i += $oldPatternYT.Length
    } else {
        $i++
    }
}

Write-Host "YouTube replacements: $replacedYT"
Write-Host ""

# === SAVE FILE ===
$totalReplacements = $replacedTG + $replacedYT
if ($totalReplacements -gt 0) {
    [System.IO.File]::WriteAllBytes('Assembly-CSharp.dll', $bytes)
    Write-Host "=== SUCCESS! ==="
    Write-Host "Total replacements: $totalReplacements"
    Write-Host "Telegram: $replacedTG"
    Write-Host "YouTube: $replacedYT"
    Write-Host "Saved to Assembly-CSharp.dll"
} else {
    Write-Host "WARNING: No replacements made"
}
