$bytes = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll.backup')
Write-Host "File size: $($bytes.Length) bytes"

# Old: https://www.youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q
# UTF-16 encoding
$oldText = "https://www.youtube.com/channel/UC5xsTxTysKUj51hVn_1tM9Q"
$newText = "https://www.youtube.com/@mk_horror"

$oldPattern = [System.Text.Encoding]::Unicode.GetBytes($oldText)
$newPattern = [System.Text.Encoding]::Unicode.GetBytes($newText)

Write-Host "Old: $oldText ($($oldPattern.Length) bytes)"
Write-Host "New: $newText ($($newPattern.Length) bytes)"

# Pad new pattern to match old length
if ($newPattern.Length -lt $oldPattern.Length) {
    $diff = $oldPattern.Length - $newPattern.Length
    $padding = ,0 * $diff
    $newPattern = $newPattern + $padding
    Write-Host "Padded new pattern to $($newPattern.Length) bytes"
}

$replaced = 0
$i = 0
while ($i -le ($bytes.Length - $oldPattern.Length)) {
    $match = $true
    for ($j = 0; $j -lt $oldPattern.Length; $j++) {
        if ($bytes[$i + $j] -ne $oldPattern[$j]) {
            $match = $false
            break
        }
    }

    if ($match) {
        Write-Host "Replacing at offset: 0x$($i.ToString('X8'))"
        for ($j = 0; $j -lt $newPattern.Length; $j++) {
            $bytes[$i + $j] = $newPattern[$j]
        }
        $replaced++
        $i += $oldPattern.Length
    } else {
        $i++
    }
}

Write-Host "Total replacements: $replaced"

if ($replaced -gt 0) {
    [System.IO.File]::WriteAllBytes('Assembly-CSharp.dll', $bytes)
    Write-Host "SUCCESS! Saved to Assembly-CSharp.dll"

    Write-Host ""
    Write-Host "Verification:"
    $verify = [System.IO.File]::ReadAllBytes('Assembly-CSharp.dll')
    $verifyOld = [System.Text.Encoding]::Unicode.GetBytes($oldText)

    $foundOld = $false
    for ($i = 0; $i -lt ($verify.Length - $verifyOld.Length); $i++) {
        $match = $true
        for ($j = 0; $j -lt $verifyOld.Length; $j++) {
            if ($verify[$i + $j] -ne $verifyOld[$j]) {
                $match = $false
                break
            }
        }
        if ($match) {
            $foundOld = $true
            break
        }
    }

    if ($foundOld) {
        Write-Host "WARNING: Old URL still found!"
    } else {
        Write-Host "OK: Old URL removed"
    }
} else {
    Write-Host "No matches found"
}
